

PROCEDURE KNAPRED(
       N       :INTEGER;
   VAR P,W     :ARR0N2;
   VAR X       :ARRN;
   VAR V,PROFIT:INTEGER;
       INF     :INTEGER;
   VAR OPTSOL  :BOOLEAN);

   VAR I,J,LB,PP,PPP,Q,QQ,R,S,VV,Y,Z,WW,WWW:INTEGER;
       B                                   :BOOLEAN;
       PR,WR                               :ARRN;
       UB                                  :ARR0N;

   PROCEDURE AUGMENT(I,K:INTEGER);
      { THE PROCEDURE AUGMENTS A PARTIAL SOLUTION WHICH WEIGHS VV
        AND HAS PROFIT Q, STARTING WITH OBJECT K+1 AND TRYING TO
        ADD AS MANY OBJECTS AS POSSIBLE (EXCEPT THE I-TH OBJECT)
        WHICH FOLLOW OBJECT K. }
      VAR KK,VVV:INTEGER;
   BEGIN
      KK:=K+1;  VVV:=VV;  QQ:=Q;
      WHILE KK <= N DO BEGIN
         IF (VVV >= W[KK]) AND (KK <> I) THEN BEGIN
            VVV:=VVV-W[KK];  QQ:=QQ+P[KK]
         END;
         KK:=KK+1
      END
   END;  { AUGMENT }

   PROCEDURE UBO(I:INTEGER);
      { UBO(I) FINDS WEIGHT VV AND PROFIT Q OF THE GREEDY SOLUTION
        OBTAINED BY ASSUMING X[I]=0, WHERE I <= R, AND TAKING AS
        MANY AS POSSIBLE CONSECUTIVE OBJECTS. UPON EXIT, QQ IS THE
        PROFIT OF THE GREEDY SOLUTION AUGMENT BY PROCEDURE AUGMENT. }
      VAR WI:INTEGER;
          BB:BOOLEAN;
   BEGIN
      WI:=W[I];  S:=R-1;  BB:=TRUE;
      WHILE (S <= N) AND BB DO
         IF WI >= WR[S] THEN S:=S+1
         ELSE BB:=FALSE;
      S:=S-1;  VV:=WI-WR[S];  Q:=PR[S]-P[I];
      AUGMENT(I,S)
   END;  { UBO }

   PROCEDURE UB1(I:INTEGER);
      { UB1(I) FINDS WEIGHT VV AND PROFIT Q OF THE GREEDY SOLUTION
        OBTAINED BY ASSUMING X[I]=1, WHERE R <= I, AND TAKING AS MANY
        AS POSSIBLE CONSECUTIVE OBJECTS. UPON EXIT, QQ IS THE PROFIT
        OF THE GREEDY SOLUTION AUGMENT BY PROCEDURE AUGMENT. }
      VAR WI:INTEGER;
   BEGIN
      WI:=W[I];  S:=R;
      WHILE WR[S] < WI DO S:=S-1;
      VV:=WR[S]-WI;  Q:=PR[S]+P[I];
      AUGMENT(I,R)
   END; { UB1 }

BEGIN                                                   { MAIN BODY }
   PP:=0;  WW:=0;  R:=1;
   WHILE WW+W[R] < V DO BEGIN
      WW:=WW+W[R];  PP:=PP+P[R];  R:=R+1
   END;
   WW:=V-WW;
   IF WW = W[R] THEN BEGIN         { THE GREEDY SOLUTION IS OPTIMAL }
      V:=0;  PROFIT:=0;
      FOR I:=1 TO R DO BEGIN
         X[I]:=1;  PROFIT:=PROFIT+P[I]
      END;
      FOR I:=R+1 TO N DO X[I]:=0;
      OPTSOL:=TRUE
   END  { IF WW = W[R] - OPTIMAL SOLUTION }
   ELSE BEGIN                                 { REDUCTION ALGORITHM }
      W[0]:=1;  W[N+1]:=INF;  W[N+2]:=INF;
      P[0]:=P[1];  P[N+1]:=0;  P[N+2]:=0;
      VV:=WW;  Q:=PP;
      AUGMENT(0,R-1);
      LB:=QQ;
      WWW:=-WW;  PPP:=PP;
      WR[R-1]:=-WW;  PR[R-1]:=PP;
      FOR I:=R TO N DO BEGIN
         WWW:=WWW+W[I];  WR[I]:=WWW;
         PPP:=PPP+P[I];  PR[I]:=PPP
      END;
      WWW:=WW+W[R-1];  PPP:=PP-P[R-1];
      FOR I:=R-2 DOWNTO 1 DO BEGIN
         WWW:=WWW+W[I];  WR[I]:=WWW;
         PPP:=PPP-P[I];  PR[I]:=PPP
      END;
      I:=1;  J:=-1;
      B:=TRUE;
      REPEAT  { UNTIL I > N }      { FINDING UPPER AND LOWER BOUNDS }
         IF B THEN UBO(I)
         ELSE BEGIN UB1(I);  S:=S-1 END;
         Y:=TRUNC(VV*P[S+2]/W[S+2]);
         Z:=TRUNC(P[S+1]-(W[S+1]-VV)*(P[S]/W[S]));
         IF Z > Y THEN Y:=Z;
         UB[I+J]:=Q+Y;
         IF QQ > LB THEN LB:=QQ;
         IF (I = R) AND B THEN BEGIN
            B:=FALSE;  J:=0;
            WR[R-1]:=WW+W[R-1];  WR[R]:=WW;
            PR[R-1]:=PP-P[R-1];  PR[R]:=PP
         END
         ELSE I:=I+1
      UNTIL I > N;
      PROFIT:=0;  J:=0;
      FOR I:=1 TO N DO X[I]:=-1;
      FOR I:=1 TO R DO
         IF UB[I-1] < LB THEN BEGIN
            J:=J+1;  X[I]:=1;  V:=V-W[I];
            PROFIT:=PROFIT+P[I]
         END;
      I:=1;
      WHILE I <= N DO BEGIN
         IF (W[I] > V) AND (X[I] = -1) THEN BEGIN
            X[I]:=0;  J:=J+1
         END;
         I:=I+1
      END;  { WHILE I <= N }
      I:=R;
      WHILE (I <= N) AND (J < N) DO BEGIN
         IF UB[I] < LB THEN BEGIN
            X[I]:=0;  J:=J+1
         END;
         I:=I+1
      END;  { WHILE (I <= N) ... }
      OPTSOL:=J = N;
      IF NOT OPTSOL THEN BEGIN
         WW:=0;
         FOR I:=1 TO N DO IF X[I] = -1 THEN WW:=WW+W[I];
         OPTSOL:=WW=V;
         IF OPTSOL THEN BEGIN
            V:=0;
            FOR I:=1 TO N DO
               IF X[I] = -1 THEN BEGIN
                  X[I]:=1;  PROFIT:=PROFIT+P[I]
               END
         END  { IF OPTSOL }
      END  { IF NOT OPTSOL - J < N }
   END  { ELSE: WW <> W[R] }
END;  { KNAPRED }

